import 'package:rad/rad.dart';

import 'package:photogram_admin_cp/import/core.dart';

import 'package:photogram_admin_cp/ui/pages/common/form_editor_page.dart';

class AppUpdateSettingsSection extends StatefulWidget {
  const AppUpdateSettingsSection({Key? key}) : super(key: key);

  @override
  _AppUpdateSettingsSectionState createState() => _AppUpdateSettingsSectionState();
}

class _AppUpdateSettingsSectionState extends State<AppUpdateSettingsSection> with AppActiveContentMixin {
  @override
  build(context) {
    return FormEditorPage(
      heading: 'App Update Settings',
      description: 'Following settings will reflect immediatly on all mobile clients if changed.',
      items: [
        SettingItem(
          intId: AppSettings.ID_SS_TEXT_API_ANDROID_UPDATE_URL,
          settingKey: AppSettings.KEY_SS_TEXT_API_ANDROID_UPDATE_URL,
          type: FieldType.text,
          leading: 'Andorid Update URL',
          placeholder: 'e.g play.store...',
          description: 'URL to show to Android users when their app requires an update.',
        ),
        SettingItem(
          intId: AppSettings.ID_SS_TEXT_API_IOS_UPDATE_URL,
          settingKey: AppSettings.KEY_SS_TEXT_API_IOS_UPDATE_URL,
          type: FieldType.text,
          leading: 'iOS Update URL',
          description: 'URL to show to iOS users when their app requires an update.',
        ),
        SettingItem(
          intId: AppSettings.ID_SS_TEXT_API_UPDATE_MESSAGE,
          settingKey: AppSettings.KEY_SS_TEXT_API_UPDATE_MESSAGE,
          type: FieldType.textarea,
          leading: 'Update Message',
          description: 'Update message to show to mobile users(Android/iOS) when their app requires an update.',
        ),
      ],
    );
  }
}
